/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.response;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.crud.ZCRMField;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonAPIResponse {
    protected HttpResponse response;
    protected JSONObject responseJSON;
    protected APIConstants.ResponseCode httpStatusCode;
    protected ResponseHeaders responseHeaders;
    protected String responseJSONRootKey;
    private ResponseInfo info;
    protected String status;

    public CommonAPIResponse() {
    }

    public CommonAPIResponse(HttpResponse response, String responseJSONRootKey) throws IOException, JSONException, ZCRMException {
        this.response = response;
        this.responseJSONRootKey = responseJSONRootKey;
        this.init();
        this.processResponse();
        this.setResponseHeaders();
        this.setInfo();
        ZCRMLogger.logInfo(this.toString());
    }

    protected void init() throws IOException, JSONException {
        this.httpStatusCode = APIConstants.ResponseCode.getEnum(this.response.getStatusLine().getStatusCode());
        this.setResponseJSON();
    }

    protected void processResponse() throws JSONException, ZCRMException {
        if (APIConstants.faultyResponseCodes.contains((Object)this.httpStatusCode)) {
            this.handleForFaultyResponses();
        } else if (this.httpStatusCode == APIConstants.ResponseCode.ACCEPTED || this.httpStatusCode == APIConstants.ResponseCode.OK || this.httpStatusCode == APIConstants.ResponseCode.CREATED) {
            this.processDataResponse();
        }
    }

    protected void handleForFaultyResponses() throws JSONException, ZCRMException {
    }

    protected void processDataResponse() throws JSONException, ZCRMException {
    }

    protected void setResponseJSON() throws IOException, JSONException {
        this.responseJSON = APIConstants.ResponseCode.NO_CONTENT == this.httpStatusCode || APIConstants.ResponseCode.NOT_MODIFIED == this.httpStatusCode ? new JSONObject() : new JSONObject(EntityUtils.toString(this.response.getEntity()));
    }

    public APIConstants.ResponseCode getStatusCode() {
        return this.httpStatusCode;
    }

    public JSONObject getResponseJSON() {
        return this.responseJSON;
    }

    protected void setResponseHeaders() {
        this.responseHeaders = new ResponseHeaders(this.response);
    }

    public ResponseHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    private void setInfo() throws JSONException {
        if (this.responseJSON.has("info") && this.responseJSON.has("private_fields")) {
            this.info = new ResponseInfo(this.responseJSON.getJSONObject("info"), this.responseJSON.getJSONArray("private_fields"));
        } else if (this.responseJSON.has("info")) {
            this.info = new ResponseInfo(this.responseJSON.getJSONObject("info"));
        } else if (this.responseJSON.has("private_fields")) {
            this.info = new ResponseInfo(this.responseJSON.getJSONArray("private_fields"));
        }
    }

    public ResponseInfo getInfo() {
        return this.info;
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return "STATUS_CODE = " + this.httpStatusCode.getCode() + " , " + "RESPONSE_JSON" + " = " + this.responseJSON + " , " + "RESPONSE_HEADERS" + " = " + this.responseHeaders.toString() + ". ";
    }

    public static class ResponseInfo {
        private boolean moreRecords;
        private int recordCount;
        private int pageNo;
        private int perPage;
        private HashMap<String, Object> fieldNameVsValue = new HashMap();
        private List<ZCRMField> privateFields = new ArrayList<ZCRMField>();

        private ResponseInfo(JSONObject info) throws JSONException {
            this(info, (JSONArray)null);
        }

        private ResponseInfo(JSONArray privateFields) throws JSONException {
            this(null, privateFields);
        }

        private ResponseInfo(JSONObject info, JSONArray privateFields) throws JSONException {
            if (info != null) {
                Iterator<String> jsonItr = info.keys();
                while (jsonItr.hasNext()) {
                    String fieldAPIName = jsonItr.next();
                    if ("more_records".equals(fieldAPIName)) {
                        this.moreRecords = info.getBoolean("more_records");
                        continue;
                    }
                    if ("page".equals(fieldAPIName)) {
                        this.pageNo = info.getInt("page");
                        continue;
                    }
                    if ("per_page".equals(fieldAPIName)) {
                        this.perPage = info.getInt("per_page");
                        continue;
                    }
                    if ("count".equals(fieldAPIName)) {
                        this.recordCount = info.getInt("count");
                        continue;
                    }
                    this.fieldNameVsValue.put(fieldAPIName, info.opt(fieldAPIName));
                }
            }
            if (privateFields != null) {
                for (int index = 0; index < privateFields.length(); ++index) {
                    JSONObject fieldDetails = privateFields.getJSONObject(index);
                    ZCRMField field = ZCRMField.getInstance(fieldDetails.getString("api_name"));
                    field.setId(Long.parseLong(fieldDetails.getString("id")));
                    if (fieldDetails.has("private") && !fieldDetails.isNull("private")) {
                        JSONObject fieldPrivateDetails = fieldDetails.getJSONObject("private");
                        field.setExportable(fieldPrivateDetails.getBoolean("export"));
                        field.setRestricted(fieldPrivateDetails.getBoolean("restricted"));
                        field.setType(CommonUtil.RestrictedType.valueOf(fieldPrivateDetails.getString("type")));
                    }
                    this.privateFields.add(field);
                }
            }
        }

        public boolean hasMoreRecords() {
            return this.moreRecords;
        }

        public int getRecordCount() {
            return this.recordCount;
        }

        public int getPageNo() {
            return this.pageNo;
        }

        public int getPerPage() {
            return this.perPage;
        }

        public List<ZCRMField> getFieldList() {
            return this.privateFields;
        }

        public Object getFieldValue(String fieldAPIName) {
            return this.fieldNameVsValue.get(fieldAPIName);
        }

        public HashMap<String, Object> getFieldNameVsValue() {
            return this.fieldNameVsValue;
        }
    }

    public static class ResponseHeaders {
        private Integer remainingCountForThisDay;
        private Integer remainingCountForThisWindow;
        private Long remainingTimeForThisWindowReset;

        public ResponseHeaders(HttpResponse response) {
            Header header = response.getFirstHeader("X-RATELIMIT-LIMIT");
            if (header != null) {
                this.remainingCountForThisDay = Integer.valueOf(header.getValue());
                this.remainingCountForThisWindow = Integer.valueOf(response.getFirstHeader("X-RATELIMIT-REMAINING").getValue());
                this.remainingTimeForThisWindowReset = Long.valueOf(response.getFirstHeader("X-RATELIMIT-RESET").getValue());
            }
        }

        public Integer getRemainingAPICountForThisDay() {
            return this.remainingCountForThisDay;
        }

        public Integer getRemainingAPICountForThisWindow() {
            return this.remainingCountForThisWindow;
        }

        public Long getRemainingTimeForThisWindowReset() {
            return this.remainingTimeForThisWindowReset;
        }

        public String toString() {
            return "X-RATELIMIT-LIMIT=" + this.remainingCountForThisDay + "; " + "X-RATELIMIT-REMAINING" + "=" + this.remainingCountForThisWindow + "; " + "X-RATELIMIT-RESET" + "=" + this.remainingTimeForThisWindowReset + "; ";
        }
    }
}

